capture log close

log using analysis.smcl, replace

global XVAR log_hy log_hnetw i.dm_age_years i.dm_gender i.em_mainjob_type i.parttime ///
	i.dm_education i.dm_citizen i.dm_ghealth i.dm_marstatus2 i.dm_hsize2 i.tempo i.country

global XVARNOT log_hy log_hnetw i.dm_age_years i.dm_gender i.em_mainjob_type i.parttime ///
	i.dm_education i.dm_citizen i.dm_ghealth i.dm_marstatus2 i.dm_hsize2 i.int_year i.country

global XVARNOY log_hy log_hnetw i.dm_age_years i.dm_gender i.em_mainjob_type i.parttime ///
	i.dm_education i.dm_citizen i.dm_ghealth i.dm_marstatus2 i.dm_hsize2 i.wave i.country

******************************************
* HETEROGENEITY BY CHARACTERISTICS	 	 *
******************************************

use reforms, clear
keep if samplesel==1

/* FIGURE 1 */
graph twoway (histogram ex_gov_age_incr, width(.01) fraction lcolor(black) lwidth(vvthin)), xtitle("Beliefs", size(large)) ///
		ytitle("Fraction",size(large)) xlabel(,labsize(large)) ylabel(,labsize(large))
	graph export "$output/figure_1a.pdf", as(pdf) replace

graph twoway (histogram ex_gov_red_pen, width(.01) fraction lcolor(black) lwidth(vvthin)), xtitle("Beliefs", size(large)) ///
		ytitle("Fraction",size(large)) xlabel(,labsize(large)) ylabel(,labsize(large))
	graph export "$output/figure_1b.pdf", as(pdf) replace

	reg ex_gov_red_pen c.log_hy c.log_hnetw c.dm_age_years i.dm_education i.em_mainjob_type i.parttime i.int_year i.dm_citizen i.dm_ghealth ///
i.dm_marstatus2 i.dm_hsize2 i.country i.int_year#i.country i.dm_gender
predict res_red_pen, res

reg ex_gov_age_incr c.log_hy c.log_hnetw c.dm_age_years i.dm_education i.em_mainjob_type i.parttime i.int_year i.dm_citizen i.dm_ghealth ///
i.dm_marstatus2 i.dm_hsize2 i.country i.int_year#i.country i.dm_gender
predict res_age_incr, res

/* FIGURE A.1 */
graph twoway (kdensity res_age_incr, lcolor(black) lwidth(thick) kernel(gaussian) bwidth(.025)), xtitle("Probabilistic Expectations", size(medlarge)) ///
		ytitle("Density",size(medlarge)) xlabel(,labsize(medlarge))
	graph export "$output/figure_A1a.pdf", as(pdf) replace
	
graph twoway (kdensity res_red_pen, lcolor(black) lwidth(thick) kernel(gaussian) bwidth(.025)), xtitle("Probabilistic Expectations", size(medlarge)) ///
		ytitle("Density",size(medlarge)) xlabel(,labsize(medlarge))
	graph export "$output/figure_A1b.pdf", as(pdf) replace

*************************************************
* DESCRIPTIVE FIGURES OF EVENTS					*
*************************************************

use reforms, clear
keep if samplesel==1
g xxx=1

foreach v in age_incr red_pen {
	recode to_reform_`v' from_reform_`v' (0=.)
	replace to_reform_`v'=to_reform_`v'-1
	replace from_reform_`v'=from_reform_`v'-1
	g event_time_`v'=-to_reform_`v' if abs(to_reform_`v')<abs(from_reform_`v')
	replace event_time_`v'=from_reform_`v' if abs(to_reform_`v')>=abs(from_reform_`v')
	replace event_time_`v'=-25 if event_time_`v'<=-25
	replace event_time_`v'=25 if event_time_`v'>=25
	g _event_time_`v'=event_time_`v'
	replace _event_time_`v'=_event_time_`v'-1 if _event_time_`v'>0
	g Qevent_time_`v'=floor(_event_time_`v'/6)
	replace Qevent_time_`v'=4 if event_time_`v'>=25
}

table Qevent_time_age_incr, c(min event_time_age_incr max event_time_age_incr)

collapse (count) obs=xxx (mean) Qevent_time_age_incr Qevent_time_red_pen timeS_reform_age_incr (mean) timeS_reform_red_pen (mean) timeS_reform_age_incr_A (mean) timeS_reform_red_pen_A, by(country int_year int_month)
sort country int_year int_month
merge 1:1 country int_year int_month using reform
recode obs .=0	
table tempo country, c(mean obs)
replace obs=1 if obs>1

g g_country=10 if country==11 /*Austria*/
replace g_country=9 if country==23 /*Belgium*/
replace g_country=8 if country==18 /*Denmark*/
replace g_country=7 if country==17 /*France*/
replace g_country=6 if country==12 /*Germany*/
replace g_country=5 if country==16 /*Italy*/
replace g_country=4 if country==14 /*Netherlands*/
replace g_country=3 if country==15 /*Spain*/
replace g_country=2 if country==13 /*Sweden*/
replace g_country=1 if country==20 /*Switzerland*/

label define country2 10 "Austria" 9 "Belgium" 8 "Denmark" 7 "France" 6 "Germany" 5 "Italy" 4 "Netherlands" 3 "Spain" 2 "Sweden" 1 "Switzerland"
label value g_country country2

tab country g_country

/* FIGURE 3 */
format tempo %tm
keep if year(dofm(tempo))>=2002
graph twoway (scatter g_country tempo if obs==1, msymbol(circle_hollow) mcolor(gs12) msize(large)) ///
	(scatter g_country tempo if reform_age_incr==1, mcolor(blue) msize(large)) ///
	(scatter g_country tempo if reform_red_pen==1, msymbol(X) mcolor(red) msize(large)), xscale(range(504 674)) xlabel(504(24)671) ///
	ylabel(1 2 3 4 5 6 7 8 9 10, valuelabel angle(0) grid labsize(medium)) yline(1 2 3 4 5 6 7 8 9 10, lcolor(gs12)) ytitle("") xtitle("") ///
		xlabel(, labsize(medsmall)) legend(label(1 "At least 30 obs in SHARE") label(2 "Reform increasing NRA") label(3 "Reform cutting benefits") row(3) size(medium))
graph export "$output/figure_3.eps", as(eps) replace

/* FIGURE 4 */
graph twoway (scatter g_country tempo if obs==1 & timeS_reform_age_incr_A==0, msymbol(circle) mcolor(gs12) msize(large)) ///
	(scatter g_country tempo if obs==1 & timeS_reform_age_incr_A==1, msymbol(Dh) mcolor(green) msize(large)) ///
	(scatter g_country tempo if obs==1 & timeS_reform_age_incr_A==2, msymbol(circle_hollow) mcolor(blue) msize(large)) ///
	(scatter g_country tempo if obs==1 & timeS_reform_age_incr_A==3, msymbol(circle) mcolor(blue) msize(large)) ///
	(scatter g_country tempo if reform_age_incr==1, mcolor(black) msymbol(X) msize(medlarge)), xscale(range(504 674)) xlabel(504(24)671) ///
	ylabel(1 2 3 4 5 6 7 8 9 10, valuelabel angle(0) grid labsize(medium)) yline(1 2 3 4 5 6 7 8 9 10, lcolor(gs12)) ytitle("") xtitle("") title("Reform increasing NRA", size(medium)) ///
		xlabel(, labsize(medsmall)) legend(label(1 "Far from reforms") label(2 "IA(-12,-1)") label(3 "IU(-12,-1)") label(4 "I(0,12)") label(5 "Reform") col(4) size(medium))
graph export "$output/figure_4a.pdf", as(pdf) replace

graph twoway (scatter g_country tempo if obs==1 & timeS_reform_red_pen_A==0, msymbol(circle) mcolor(gs12) msize(large)) ///
	(scatter g_country tempo if obs==1 & timeS_reform_red_pen_A==1, msymbol(Dh) mcolor(orange) msize(large)) ///
	(scatter g_country tempo if obs==1 & timeS_reform_red_pen_A==2, msymbol(circle_hollow) mcolor(red) msize(large)) ///
	(scatter g_country tempo if obs==1 & timeS_reform_red_pen_A==3, msymbol(circle) mcolor(red) msize(large)) ///
	(scatter g_country tempo if reform_red_pen==1, mcolor(black) msymbol(X) msize(medlarge)), xscale(range(504 674)) xlabel(504(24)671) ///
	ylabel(1 2 3 4 5 6 7 8 9 10, valuelabel angle(0) grid labsize(medium)) yline(1 2 3 4 5 6 7 8 9 10, lcolor(gs12)) ytitle("") xtitle("") title("Reform cutting benefits", size(medium)) ///
		xlabel(, labsize(medsmall)) legend(label(1 "Far from reforms") label(2 "IA(-12,-1)") label(3 "IU(-12,-1)") label(4 "I(0,12)") label(5 "Reform") col(4) size(medium))
graph export "$output/figure_4b.pdf", as(pdf) replace

*************************************************
* TABLE DESCRIPTIVE								*
*************************************************
use reforms, clear
keep if samplesel==1

/* TABLE A.3 */
tab country wave

/* TABLE A.4 */
tab timeS_reform_age_incr_A
tab timeS_reform_red_pen_A

g mm=dm_numeracy>=1 & dm_numeracy<=5
egen tmm=sum(mm), by(pid)
tab tmm
egen avg_numeracy=mean(dm_numeracy), by(pid)

sum avg_numeracy, d
replace avg_numeracy=avg_numeracy-r(mean)

replace google6=google6/100
replace google12=google12/100
replace dm_gender=dm_gender-1
replace dm_citizen=0 if dm_citizen==5

g risk_av=ex_risk_av==4
replace risk_av=. if ex_risk_av==. | ex_risk_av==.a | ex_risk_av==.b

/* TABLE 1 */
xi: tabstat dm_age_years dm_gender i.em_mainjob_type parttime ///
	i.dm_education dm_citizen i.dm_ghealth i.dm_marstatus2 dm_hsize2 log_hy log_hnetw   ///
	ex_gov_age_incr ex_gov_red_pen i.timeS_reform_age_incr_A i.timeS_reform_red_pen_A ///
	google6 news_nexis_rescmax6 avg_numeracy, ///
	col(stat) stat(mean sd p50 min max count)

*************************************************
* MAIN RESULTS									*
*************************************************

use reforms, clear
keep if samplesel==1

tab timeS6_reform_age_incr
tab timeS6_reform_red_pen 

tab timeS_reform_age_incr
tab timeS_reform_red_pen

tab timeS18_reform_age_incr
tab timeS18_reform_red_pen 

sum ptr_to_age_incr ptr_from_age_incr 
sum ptr_to_red_pen ptr_from_red_pen  

sum ex_gov_age_incr ex_gov_red_pen 

replace unemprate=unemprate/100
replace intrate=intrate/100
replace centgovdebt=centgovdebt/100
replace netlend=netlend/100

g log_gdphead=log(gdphead)	

xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr $XVAR, cluster(gruppo) small partial(i.tempo)
est store blockS_age

xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen $XVAR, cluster(gruppo) small partial(i.tempo)
est store blockS_pen

xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr unemprate log_gdphead intrate centgovdebt netlend $XVAR, cluster(gruppo) small partial($XVAR) 
est store macro2_ageincr
 
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen unemprate log_gdphead intrate centgovdebt netlend $XVAR, cluster(gruppo) small partial($XVAR)
est store macro2_redpen

/* TABLE 2 */
esttab blockS_age macro2_ageincr blockS_pen macro2_redpen using "$output/table2.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS* unemprate log_gdphead intrate centgovdebt netlend) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances age incr" "Chances red pen" "Chances red pen") ///
	nogaps replace
* Table 2, I(.,.) and dependent variables average	
sum i.timeS_reform_age_incr i.timeS_reform_red_pen ex_gov_age_incr ex_gov_red_pen

* Check footnote 15
tab country tempo if inv_to_reform_age_incr==inv_from_reform_age_incr & inv_to_reform_age_incr!=0
tab country tempo if inv_to_reform_red_pen==inv_from_reform_red_pen & inv_to_reform_red_pen!=0
g case=inv_to_reform_red_pen==inv_from_reform_red_pen & inv_to_reform_red_pen!=0

xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr $XVAR if case==0, cluster(gruppo) small partial($XVAR )
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen $XVAR if case==0, cluster(gruppo) small partial($XVAR )

* Check footnote 21 (no Switzerland)
xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr_A $XVAR if country!=23, cluster(gruppo) small partial(i.tempo)
est store blockSA_age
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen_A $XVAR if country!=23, cluster(gruppo) small partial(i.tempo)
est store blockSA_pen

*************************************************
* ROUNDING										*
*************************************************

use reforms, clear
keep if samplesel==1

merge 1:1 country wave mergeid using rounding
keep if _merge==3
foreach var in Rex_gov_red_penL Rex_gov_age_incrL Rex_gov_red_penU Rex_gov_age_incrU or_ex_gov_red_pen or_ex_gov_age_incr {
	g _`var'=`var'/100
	drop `var'
	ren _`var' `var'
}

xtsum T

/* TABLE A.10 */
tab T, miss

tab timeS_reform_age_incr, g(DtimeS_reform_age_incr)
tab timeS_reform_red_pen, g(DtimeS_reform_red_pen)

foreach var in age_incr red_pen {
	forvalues i=2(1)3 {
		if `i'==2 {
			local l=3
			}
		else {
			local l=2
		}
		quietly reg DtimeS_reform_`var'`i' DtimeS_reform_`var'`l' $XVAR
		predict RDtimeS_reform_`var'`i', res
		g MINDtimeS_reform_`var'`i'=min(RDtimeS_reform_`var'`i'*Rex_gov_`var'L, RDtimeS_reform_`var'`i'*Rex_gov_`var'U)
		g ADtimeS_reform_`var'`i'=RDtimeS_reform_`var'`i'*ex_gov_`var'
		g MAXDtimeS_reform_`var'`i'=max(RDtimeS_reform_`var'`i'*Rex_gov_`var'L, RDtimeS_reform_`var'`i'*Rex_gov_`var'U)
		
		g minDtimeS_reform_`var'`i'=Rex_gov_`var'L if RDtimeS_reform_`var'`i'*Rex_gov_`var'L<=RDtimeS_reform_`var'`i'*Rex_gov_`var'U
		replace minDtimeS_reform_`var'`i'=Rex_gov_`var'U if RDtimeS_reform_`var'`i'*Rex_gov_`var'L>RDtimeS_reform_`var'`i'*Rex_gov_`var'U
		g maxDtimeS_reform_`var'`i'=Rex_gov_`var'L if RDtimeS_reform_`var'`i'*Rex_gov_`var'L>=RDtimeS_reform_`var'`i'*Rex_gov_`var'U
		replace maxDtimeS_reform_`var'`i'=Rex_gov_`var'U if RDtimeS_reform_`var'`i'*Rex_gov_`var'L<RDtimeS_reform_`var'`i'*Rex_gov_`var'U

	}
}

/* TABLE 3 COLUMNS i-iii */

* Panel A: coefficients and CI
xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr $XVAR, cluster(gruppo) small partial($XVAR)
xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr $XVAR if T>=4, cluster(gruppo) small partial($XVAR)
xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr $XVAR if T>=5, cluster(gruppo) small partial($XVAR)

quietly reg ex_gov_age_incr i.timeS_reform_age_incr $XVAR
est store uno
quietly reg ex_gov_age_incr i.timeS_reform_age_incr $XVAR if T>=4
est store due
quietly reg ex_gov_age_incr i.timeS_reform_age_incr $XVAR if T>=5
est store tre

suest uno due tre, cluster(gruppo)
* Panel A: Tests for equality
test ([uno_mean]1.timeS_reform_age_incr=[due_mean]1.timeS_reform_age_incr) ([uno_mean]2.timeS_reform_age_incr=[due_mean]2.timeS_reform_age_incr) 
test ([uno_mean]1.timeS_reform_age_incr=[tre_mean]1.timeS_reform_age_incr) ([uno_mean]2.timeS_reform_age_incr=[tre_mean]2.timeS_reform_age_incr)

* Panel B: coefficients and CI
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen $XVAR, cluster(gruppo) small partial($XVAR)
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen $XVAR if T>=4, cluster(gruppo) small partial($XVAR)
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen $XVAR if T>=5, cluster(gruppo) small partial($XVAR)

quietly reg ex_gov_red_pen i.timeS_reform_red_pen $XVAR
est store uno
quietly reg ex_gov_red_pen i.timeS_reform_red_pen $XVAR if T>=4
est store due
quietly reg ex_gov_red_pen i.timeS_reform_red_pen $XVAR if T>=5
est store tre

suest uno due tre, cluster(gruppo)
* Panel B: Tests for equality
test ([uno_mean]1.timeS_reform_red_pen=[due_mean]1.timeS_reform_red_pen) ([uno_mean]2.timeS_reform_red_pen=[due_mean]2.timeS_reform_red_pen) 
test ([uno_mean]1.timeS_reform_red_pen=[tre_mean]1.timeS_reform_red_pen) ([uno_mean]2.timeS_reform_red_pen=[tre_mean]2.timeS_reform_red_pen)

* Check on the routine
reg ex_gov_age_incr RDtimeS_reform_age_incr2, cluster(gruppo)
reg ex_gov_age_incr RDtimeS_reform_age_incr3, cluster(gruppo)

reg minDtimeS_reform_age_incr2 RDtimeS_reform_age_incr2, cluster(gruppo)
reg maxDtimeS_reform_age_incr2 RDtimeS_reform_age_incr2, cluster(gruppo)

xi: oneDproj Rex_gov_age_incrL Rex_gov_age_incrU  DtimeS_reform_age_incr2 DtimeS_reform_age_incr3 $XVAR 	
* it works as expected 

/* TABLE 3 COLUMNS iv-ix */

* For the table, this produces first results for columns iv-ix for BNRA (Panel A), then for BPB (Panel B)
* For the LB/UB, look for "Bounds for Parameter 1" (for I(-12,-1)) and "Bounds for Parameter 2" (for I(0,12))
* For the Confidence set, look for "Parameter 1: Confidence Set based on directed Hausdorff" and "Parameter 2: Confidence Set based on directed Hausdorff"
* random.org, 12/03/2020, integer between 1 and 999999
set seed 976957 
foreach var in age_incr red_pen {
	xi: CI1D_cluster Rex_gov_`var'L Rex_gov_`var'U  DtimeS_reform_`var'2 DtimeS_reform_`var'3 $XVAR, cluster(gruppo) reps(1000) level(0.95) nocc
	preserve
	keep if T>=4
	xi: CI1D_cluster Rex_gov_`var'L Rex_gov_`var'U  DtimeS_reform_`var'2 DtimeS_reform_`var'3 $XVAR, cluster(gruppo) reps(1000) level(0.95) nocc
	keep if T>=5
	xi: CI1D_cluster Rex_gov_`var'L Rex_gov_`var'U  DtimeS_reform_`var'2 DtimeS_reform_`var'3 $XVAR, cluster(gruppo) reps(1000) level(0.95) nocc
	restore
}

* Check without clustering
* random.org, 12/03/2020, integer between 1 and 999999
set seed 976957 
foreach var in age_incr red_pen {
	xi: CI1D Rex_gov_`var'L Rex_gov_`var'U  DtimeS_reform_`var'2 DtimeS_reform_`var'3 $XVAR, reps(100) level(0.95) nocc
	preserve
	keep if T>=4
	xi: CI1D Rex_gov_`var'L Rex_gov_`var'U  DtimeS_reform_`var'2 DtimeS_reform_`var'3 $XVAR, reps(100) level(0.95) nocc
	keep if T>=5
	xi: CI1D Rex_gov_`var'L Rex_gov_`var'U  DtimeS_reform_`var'2 DtimeS_reform_`var'3 $XVAR, reps(100) level(0.95) nocc
	restore
}	


*************************************************
* LONGITUDINAL ESTIMATES						*
*************************************************
use reforms, clear
keep if samplesel==1

g wwave=wave
replace wwave=3 if wave==4
replace wwave=4 if wave==5

xtset pid wwave

quietly xtreg ex_gov_age_incr i.timeS_reform_age_incr $XVAR, fe cluster(init_hhid)
g x1=e(sample)==1
egen tot_x1=sum(x1), by(mergeid)
tab timeS_reform_age_incr if tot_x1>1
reg ex_gov_age_incr i.timeS_reform_age_incr $XVAR if tot_x1>1, cluster(init_hhid)
est store blockS_ageOLS
xtreg ex_gov_age_incr i.timeS_reform_age_incr $XVAR if tot_x1>1, fe cluster(init_hhid)
est store blockS_age
drop x1 tot_x1

quietly xtreg ex_gov_red_pen i.timeS_reform_red_pen $XVAR, fe cluster(init_hhid)
g x1=e(sample)==1
egen tot_x1=sum(x1), by(mergeid)
tab timeS_reform_red_pen if tot_x1>1
reg ex_gov_red_pen i.timeS_reform_red_pen $XVAR if tot_x1>1, cluster(init_hhid)
est store blockS_penOLS
xtreg ex_gov_red_pen i.timeS_reform_red_pen $XVAR if tot_x1>1, fe cluster(init_hhid)
est store blockS_pen
drop x1 tot_x1

/* TABLE 4 */

esttab blockS_ageOLS blockS_penOLS using "$output/table4.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("OLS") ///
	nogaps replace
	
esttab blockS_age blockS_pen using "$output/table4.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("FE") ///
	nogaps append

* For first differences, start from non-selected sample in order to preserve sample size
use reforms, clear
replace wave=wave-1 if wave>=4
xtset pid wave

foreach var in age_incr red_pen {
	tab timeS_reform_`var', g(DtimeS_reform_`var')
	g d_DtimeS_reform_`var'1=DtimeS_reform_`var'1-l.DtimeS_reform_`var'1
	g d_DtimeS_reform_`var'2=DtimeS_reform_`var'2-l.DtimeS_reform_`var'2
	g d_DtimeS_reform_`var'3=DtimeS_reform_`var'3-l.DtimeS_reform_`var'3
	}
	
tab dm_age_years, g(Idm_age_years)
tab em_mainjob_type, g(Iem_mainjob_type)
tab dm_ghealth, g(Idm_ghealth)
tab dm_marstatus2, g(Idm_marstatus2)
tab dm_hsize2, g(Idm_hsize2)
tab tempo, g(Itempo)

global DXVAR D.log_hy D.log_hnetw D.parttime D.Idm_age_years* D.Iem_mainjob_type* ///
	D.Idm_ghealth* D.Idm_marstatus2* D.Idm_hsize2* i.tempo
drop Idm_age_years1
drop Iem_mainjob_type1
drop Idm_ghealth1
drop Idm_marstatus21
drop Idm_hsize21

reg D.ex_gov_age_incr d_DtimeS_reform_age_incr2 d_DtimeS_reform_age_incr3 $DXVAR if samplesel==1, cluster(gruppo) 
est store fd1
reg D.ex_gov_red_pen d_DtimeS_reform_red_pen2 d_DtimeS_reform_red_pen3 $DXVAR if samplesel==1, cluster(gruppo) 
est store fd2

esttab fd1 fd2 using "$output/table4.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("FD") ///
	nogaps append	
	
	
*****************************************
* LAGGED BELIEFS  						*
*****************************************
	
use reforms, clear
replace wave=wave-1 if wave>=4
xtset pid wave

g l_ex_gov_age_incr=l.ex_gov_age_incr
g l_ex_gov_red_pen=l.ex_gov_red_pen
g double d_ex_gov_age_incr=ex_gov_age_incr-l.ex_gov_age_incr
g double d_ex_gov_red_pen=ex_gov_red_pen-l.ex_gov_red_pen

foreach var in age_incr red_pen {
	g l_timeS_reform_`var'=l.timeS_reform_`var'
	tab timeS_reform_`var', g(DtimeS_reform_`var')
	g d_DtimeS_reform_`var'1=DtimeS_reform_`var'1-l.DtimeS_reform_`var'1
	g d_DtimeS_reform_`var'2=DtimeS_reform_`var'2-l.DtimeS_reform_`var'2
	g d_DtimeS_reform_`var'3=DtimeS_reform_`var'3-l.DtimeS_reform_`var'3
	}
	
tab l_timeS_reform_age_incr if d_DtimeS_reform_age_incr2==1
tab l_timeS_reform_age_incr if d_DtimeS_reform_age_incr3==1

g l_int_year=l.int_year
g l_tempo=l.tempo
g dt=tempo-l.tempo
replace dt=dt/12

tab l_timeS_reform_age_incr, g(Dl_timeS_reform_age_incr)

g l_ex_ageXDtS_age2=l_ex_gov_age_incr*DtimeS_reform_age_incr2
g l_ex_ageXDl_tS_age2=l_ex_gov_age_incr*Dl_timeS_reform_age_incr2
g DtimeS_age2XDl=DtimeS_reform_age_incr2*Dl_timeS_reform_age_incr2
g l_ageXDtS_age2XDl_tS_age2=l_ex_gov_age_incr*DtimeS_age2XDl

tab l_timeS_reform_red_pen, g(Dl_timeS_reform_red_pen)

g l_ex_penXDtS_pen2=l_ex_gov_red_pen*DtimeS_reform_red_pen2
g l_ex_penXDl_tS_pen2=l_ex_gov_red_pen*Dl_timeS_reform_red_pen2
g DtimeS_pen2XDl=DtimeS_reform_red_pen2*Dl_timeS_reform_red_pen2
g l_penXDtS_pen2XDl_tS_pen2=l_ex_gov_red_pen*DtimeS_pen2XDl

* cross
g l_ex_penXDtS_age2=l_ex_gov_red_pen*DtimeS_reform_age_incr2
g l_ex_penXDl_tS_age2=l_ex_gov_red_pen*Dl_timeS_reform_age_incr2
g l_penXDtS_age2XDl_tS_age2=l_ex_gov_red_pen*DtimeS_age2XDl

g l_ex_ageXDtS_pen2=l_ex_gov_age_incr*DtimeS_reform_red_pen2
g l_ex_ageXDl_tS_pen2=l_ex_gov_age_incr*Dl_timeS_reform_red_pen2
g l_ageXDtS_pen2XDl_tS_pen2=l_ex_gov_age_incr*DtimeS_pen2XDl


xi: ivreg2 ex_gov_age_incr DtimeS_reform_age_incr2 Dl_timeS_reform_age_incr2 l_ex_gov_age_incr ///
	l_ex_ageXDtS_age2 l_ex_ageXDl_tS_age2 if samplesel==1, cluster(gruppo) small
est store one

xi: ivreg2 ex_gov_age_incr DtimeS_reform_age_incr2 Dl_timeS_reform_age_incr2 l_ex_gov_age_incr ///
	l_ex_ageXDtS_age2 l_ex_ageXDl_tS_age2 $XVAR if samplesel==1, cluster(gruppo) small partial($XVAR)
est store two

xi: ivreg2 ex_gov_red_pen DtimeS_reform_red_pen2 Dl_timeS_reform_red_pen2 l_ex_gov_red_pen ///
	l_ex_penXDtS_pen2 l_ex_penXDl_tS_pen2 if samplesel==1, cluster(gruppo) small
est store three

xi: ivreg2 ex_gov_red_pen DtimeS_reform_red_pen2 Dl_timeS_reform_red_pen2 l_ex_gov_red_pen ///
	l_ex_penXDtS_pen2 l_ex_penXDl_tS_pen2 $XVAR if samplesel==1, cluster(gruppo) small partial($XVAR)
est store four

/* TABLE 5 */
esttab one two three four using "$output/table5.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS* *ex_gov* *DtS* *Dl_tS* _cons) ///
	starlevels(* .10 ** .05 *** .01)   ///
	nogaps replace
	
	
******************************
* ANNOUNCEMENTS	AND MEDIA	 *
******************************

use reforms, clear
keep if samplesel==1

tab timeS_reform_age_incr_A
tab timeS_reform_red_pen_A

replace google=google/100
replace google6=google6/100

/* FIGURE A.2 */
graph twoway  (kdensity google, lcolor(black) lpattern(dash) lwidth(medthick)) (kdensity google6, lcolor(black) lwidth(medthick)) ///
				(kdensity news_nexis_rescmax6, lcolor(red) lwidth(medthick)),	///
			xtitle("Google Trends Index / News Index", size(small)) ytitle("Density",size(small)) xlabel(,labsize(small)) ///
			legend(label(1 "G(0)") label(2 "G(6)") label(3 "News(6)")  size(small) cols(2)) ///
			xlabel(, labsize(small)) ylabel(, labsize(small))
	graph export "$output/figure_A2.pdf", as(pdf) replace

/* FIGURE A.3 */
preserve
	collapse (mean)  news_nexis_rescmax6 google6, by(country tempo)
	keep if news_nexis_rescmax6!=. & google6!=.
	graph twoway (scatter news_nexis_rescmax6 google6) (lfit news_nexis_rescmax6 google6), ///
			 xtitle("G(6)") ytitle("News(6)") xlabel(,labsize(small)) legend(off) ///
			xlabel(, labsize(small)) ylabel(, labsize(small))
	graph export "$output/figure_A3.pdf", as(pdf) replace
restore

xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr_A $XVAR, cluster(gruppo) small partial($XVAR)
est store blockSA_age
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen_A $XVAR, cluster(gruppo) small partial($XVAR)
est store blockSA_pen

xi: ivreg2 ex_gov_age_incr google6 $XVAR, cluster(gruppo) small partial($XVAR)
est store google_age
xi: ivreg2 ex_gov_red_pen google6 $XVAR, cluster(gruppo) small partial($XVAR)
est store google_pen

xi: ivreg2 ex_gov_age_incr news_nexis_rescmax6 $XVAR, cluster(gruppo) small partial($XVAR)
est store news_nexis_age
xi: ivreg2 ex_gov_red_pen news_nexis_rescmax6 $XVAR, cluster(gruppo) small partial($XVAR)
est store news_nexis_pen
 
/* TABLE 6 */

esttab blockSA_age blockSA_pen using "$output/table6.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(_Itime*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel A") ///
	nogaps replace	
	
esttab google_age google_pen using "$output/table6.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*google*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel B") ///
	nogaps append	
	
esttab news_nexis_age news_nexis_pen using "$output/table6.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*news*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel C") ///
	nogaps append	
	
* Table 6: averages for I(.,.), G(6) and News(6)
sum i.timeS_reform_age_incr_A i.timeS_reform_red_pen_A google6 news_nexis_rescmax6

	
foreach xx in age_incr red_pen {
	
	tab timeS_reform_`xx'_A, g(DtimeS_reform_`xx'_A)
	g GXDtimeS_reform_`xx'_A2=google6*DtimeS_reform_`xx'_A2
	g GXDtimeS_reform_`xx'_A3=google6*DtimeS_reform_`xx'_A3
	g GXDtimeS_reform_`xx'_A4=google6*DtimeS_reform_`xx'_A4

	xi: ivreg2 ex_gov_`xx' DtimeS_reform_`xx'_A2 DtimeS_reform_`xx'_A3 DtimeS_reform_`xx'_A4 google6 $XVAR, cluster(gruppo) small partial($XVAR)
	est store fullinfo_`xx'_1

	xi: ivreg2 ex_gov_`xx' DtimeS_reform_`xx'_A2 DtimeS_reform_`xx'_A3 DtimeS_reform_`xx'_A4 ///
		GXDtimeS_reform_`xx'_A2 GXDtimeS_reform_`xx'_A3 GXDtimeS_reform_`xx'_A4 google6 $XVAR, cluster(gruppo) small partial($XVAR)
	est store fullinfo_`xx'_2

	test google6+GXDtimeS_reform_`xx'_A2=0
	test google6+GXDtimeS_reform_`xx'_A3=0
	test google6+GXDtimeS_reform_`xx'_A4=0
	}    

/* TABLE 7 */
esttab fullinfo_age_incr_1 fullinfo_age_incr_2 fullinfo_red_pen_1 fullinfo_red_pen_2 using "$output/table7.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(Dtime* google* GXD*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") ///
	nogaps replace
	
/* FIGURE A.5 */
preserve
	xi: ivreg2 ex_gov_age_incr DtimeS_reform_age_incr_A2 DtimeS_reform_age_incr_A3 DtimeS_reform_age_incr_A4 GXDtimeS_reform_age_incr_A2 GXDtimeS_reform_age_incr_A3 GXDtimeS_reform_age_incr_A4 google6 $XVAR, cluster(gruppo) small partial($XVAR)
	
	use reforms, clear
	keep if samplesel==1
	replace google6=google6/100
	keep if google6!=.
	xtile G=google6, nq(100)
	collapse (mean) google6, by(G)
	replace G=10 if G==1

	keep if G>=10 & G<=90

	di _b[DtimeS_reform_age_incr_A2]
	di _b[GXDtimeS_reform_age_incr_A2]
	di _b[DtimeS_reform_age_incr_A3]
	di _b[GXDtimeS_reform_age_incr_A3]
	di _b[DtimeS_reform_age_incr_A4]
	di _b[GXDtimeS_reform_age_incr_A4]
	
	g IA=_b[DtimeS_reform_age_incr_A2]+_b[GXDtimeS_reform_age_incr_A2]*google6
	g IU=_b[DtimeS_reform_age_incr_A3]+_b[GXDtimeS_reform_age_incr_A3]*google6
	g IP=_b[DtimeS_reform_age_incr_A4]+_b[GXDtimeS_reform_age_incr_A4]*google6
	graph twoway (line IA G, lcolor(red) lwidth(thick) lpattern(solid)) (line IU G, lcolor(blue) lwidth(thick) lpattern(longdash)) ///
		(line IP G, lcolor(black) lwidth(thick) lpattern(dash)), ///
		xtitle("Percentile of G(6)", size(medium)) xscale(range(0 100)) xtick(10(10)90)  xlabel(10(20)90,labsize(medium)) ylabel(,labsize(medium)) legend(cols(3) ///
		label(1 "IA(-12,-1)") label(2 "IU(-12,-1)") label(3 "I(0,12)") size(medium))
		graph export "$output/figure_A5a.pdf", as(pdf) replace
restore

preserve
	xi: ivreg2 ex_gov_red_pen DtimeS_reform_red_pen_A2 DtimeS_reform_red_pen_A3 DtimeS_reform_red_pen_A4 GXDtimeS_reform_red_pen_A2 GXDtimeS_reform_red_pen_A3 GXDtimeS_reform_red_pen_A4 google6 $XVAR, cluster(gruppo) small partial($XVAR)
	
	use reforms, clear
	keep if samplesel==1
	replace google6=google6/100
	keep if google6!=.
	xtile G=google6, nq(100)
	collapse (mean) google6, by(G)
	replace G=10 if G==1

	keep if G>=10 & G<=90		
	
	di _b[DtimeS_reform_red_pen_A2]
	di _b[GXDtimeS_reform_red_pen_A2]
	di _b[DtimeS_reform_red_pen_A3]
	di _b[GXDtimeS_reform_red_pen_A3]
	di _b[DtimeS_reform_red_pen_A4]
	di _b[GXDtimeS_reform_red_pen_A4]
	g IAB=_b[DtimeS_reform_red_pen_A2]+_b[GXDtimeS_reform_red_pen_A2]*google6
	g IUB=_b[DtimeS_reform_red_pen_A3]+_b[GXDtimeS_reform_red_pen_A3]*google6
	g IPB=_b[DtimeS_reform_red_pen_A4]+_b[GXDtimeS_reform_red_pen_A4]*google6
	graph twoway (line IAB G, lcolor(red) lwidth(thick) lpattern(solid)) (line IUB G, lcolor(blue) lwidth(thick) lpattern(longdash)) ///
		(line IPB G, lcolor(black) lwidth(thick) lpattern(dash)), ///
		xtitle("Percentile of G(6)", size(medium)) xscale(range(0 100)) xtick(10(10)90) xlabel(10(20)90,labsize(medium)) ylabel(-0.05(0.05).20,labsize(medium)) legend(cols(3) ///
		label(1 "IA(-12,-1)") label(2 "IU(-12,-1)") label(3 "I(0,12)") size(medium))
		graph export "$output/figure_A5b.pdf", as(pdf) replace	
restore


replace unemprate=unemprate/100
replace intrate=intrate/100
replace centgovdebt=centgovdebt/100
replace netlend=netlend/100
g log_gdphead=log(gdphead)

foreach xx in age_incr red_pen {

	xi: ivreg2 ex_gov_`xx' DtimeS_reform_`xx'_A2 DtimeS_reform_`xx'_A3 DtimeS_reform_`xx'_A4 google6 $XVAR unemprate log_gdphead intrate centgovdebt netlend, cluster(gruppo) small partial($XVAR)
	est store fullinfo_`xx'_panel1

	xi: ivreg2 ex_gov_`xx' DtimeS_reform_`xx'_A2 DtimeS_reform_`xx'_A3 DtimeS_reform_`xx'_A4 ///
		GXDtimeS_reform_`xx'_A2 GXDtimeS_reform_`xx'_A3 GXDtimeS_reform_`xx'_A4 google6 $XVAR unemprate log_gdphead intrate centgovdebt netlend, cluster(gruppo) small partial($XVAR)
	est store fullinfo_`xx'_panel2

	}    

/* TABLE A.12 Panel A*/
esttab fullinfo_age_incr_panel1 fullinfo_age_incr_panel2 fullinfo_red_pen_panel1 fullinfo_red_pen_panel2 using "$output/tableA_12.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(Dtime* google* GXD* unemprate log_gdphead intrate centgovdebt netlend) order(Dtime* google* GXD* unemprate log_gdphead intrate centgovdebt netlend) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel A") ///
	nogaps replace	

g wwave=wave
replace wwave=3 if wave==4
replace wwave=4 if wave==5
xtset pid wwave

quietly xi: ivreg2 ex_gov_age_incr DtimeS_reform_age_incr_A2 DtimeS_reform_age_incr_A3 DtimeS_reform_age_incr_A4 google6 $XVAR, cluster(gruppo) small partial($XVAR)
g x1=e(sample)==1
egen tot_x1=sum(x1), by(mergeid)

foreach xx in age_incr red_pen {

	xtreg ex_gov_`xx' DtimeS_reform_`xx'_A2 DtimeS_reform_`xx'_A3 DtimeS_reform_`xx'_A4 google6 $XVAR if tot_x1>1, cluster(init_hhid) fe
	est store fullinfo_`xx'_panel1

	xtreg ex_gov_`xx' DtimeS_reform_`xx'_A2 DtimeS_reform_`xx'_A3 DtimeS_reform_`xx'_A4 ///
		GXDtimeS_reform_`xx'_A2 GXDtimeS_reform_`xx'_A3 GXDtimeS_reform_`xx'_A4 google6 $XVAR if tot_x1>1, cluster(init_hhid) fe
	est store fullinfo_`xx'_panel2

	}    

/* TABLE A.12 Panel B*/
esttab fullinfo_age_incr_panel1 fullinfo_age_incr_panel2 fullinfo_red_pen_panel1 fullinfo_red_pen_panel2 using "$output/tableA_12.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(Dtime* google* GXD*) order(Dtime* google* GXD*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel B") ///
	nogaps append	
	
*************************************************
* HETEROGENEITY									*
*************************************************
use reforms, clear
keep if samplesel==1

g mm=dm_numeracy>=1 & dm_numeracy<=5
egen tmm=sum(mm), by(pid)
tab tmm
egen avg_numeracy=mean(dm_numeracy), by(pid)

sum avg_numeracy, d
replace avg_numeracy=avg_numeracy-r(mean)

g univ=dm_education==4
tab dm_education, g(Ddm_education)

sum log_hnetw, d
* Deaverage household wealth by age, education, marital status, hsize, country wave
reg log_hnetw i.dm_age_years i.dm_education i.dm_marstatus2 i.dm_hsize2 i.country##i.wave
predict deavg_log_hnetw, res

g female=dm_gender==2

tab timeS_reform_age_incr_A, g(DtimeageS_A_)
g DtimeageS_A_2Xuniv=DtimeageS_A_2*univ
g DtimeageS_A_3Xuniv=DtimeageS_A_3*univ
g DtimeageS_A_4Xuniv=DtimeageS_A_4*univ
g DtimeageS_A_2Xage=DtimeageS_A_2*(dm_age_years-50)
g DtimeageS_A_3Xage=DtimeageS_A_3*(dm_age_years-50)
g DtimeageS_A_4Xage=DtimeageS_A_4*(dm_age_years-50)
g DtimeageS_A_2Xfemale=DtimeageS_A_2*female
g DtimeageS_A_3Xfemale=DtimeageS_A_3*female
g DtimeageS_A_4Xfemale=DtimeageS_A_4*female

tab timeS_reform_red_pen_A, g(DtimepenS_A_)
g DtimepenS_A_2Xuniv=DtimepenS_A_2*univ
g DtimepenS_A_3Xuniv=DtimepenS_A_3*univ
g DtimepenS_A_4Xuniv=DtimepenS_A_4*univ
g DtimepenS_A_2Xage=DtimepenS_A_2*(dm_age_years-50)
g DtimepenS_A_3Xage=DtimepenS_A_3*(dm_age_years-50)
g DtimepenS_A_4Xage=DtimepenS_A_4*(dm_age_years-50)
g DtimepenS_A_2Xfemale=DtimepenS_A_2*female
g DtimepenS_A_3Xfemale=DtimepenS_A_3*female
g DtimepenS_A_4Xfemale=DtimepenS_A_4*female

global XVARNOGENDER log_hy log_hnetw i.dm_age_years i.em_mainjob_type i.parttime ///
	i.dm_education i.dm_citizen i.dm_ghealth i.dm_marstatus2 i.dm_hsize2 i.tempo i.country

global XVAR3 log_hy log_hnetw i.dm_age_years i.dm_gender i.em_mainjob_type i.parttime ///
	i.dm_citizen i.dm_ghealth i.dm_marstatus2 i.dm_hsize2 i.tempo i.country

global XVARNOAGE log_hy log_hnetw i.dm_gender i.em_mainjob_type i.parttime ///
	i.dm_education i.dm_citizen i.dm_ghealth i.dm_marstatus2 i.dm_hsize2 i.tempo i.country
g rage=(dm_age_years-50)

reg ex_gov_age_incr DtimeageS_A_2 DtimeageS_A_3 DtimeageS_A_4 DtimeageS_A_2Xuniv DtimeageS_A_3Xuniv DtimeageS_A_4Xuniv i.dm_education $XVAR3, cluster(gruppo) 
est store age_1
reg ex_gov_red_pen DtimepenS_A_2 DtimepenS_A_3 DtimepenS_A_4 DtimepenS_A_2Xuniv DtimepenS_A_3Xuniv DtimepenS_A_4Xuniv i.dm_education $XVAR3, cluster(gruppo) 
est store pen_1

reg ex_gov_age_incr i.timeS_reform_age_incr_A i.timeS_reform_age_incr_A#c.avg_numeracy avg_numeracy $XVAR3, cluster(gruppo)
est store age_2
reg ex_gov_red_pen i.timeS_reform_red_pen_A i.timeS_reform_red_pen_A#c.avg_numeracy avg_numeracy $XVAR3, cluster(gruppo)  
est store pen_2

reg ex_gov_age_incr DtimeageS_A_2 DtimeageS_A_3 DtimeageS_A_4 DtimeageS_A_2Xage DtimeageS_A_3Xage DtimeageS_A_4Xage c.rage $XVARNOAGE, cluster(gruppo) 
est store age_3
reg ex_gov_red_pen DtimepenS_A_2 DtimepenS_A_3 DtimepenS_A_4 DtimepenS_A_2Xage DtimepenS_A_3Xage DtimepenS_A_4Xage c.rage $XVARNOAGE, cluster(gruppo) 
est store pen_3

reg ex_gov_age_incr DtimeageS_A_2 DtimeageS_A_3 DtimeageS_A_4 DtimeageS_A_2Xfemale DtimeageS_A_3Xfemale DtimeageS_A_4Xfemale female $XVARNOGENDER, cluster(gruppo) 
est store age_4
reg ex_gov_red_pen DtimepenS_A_2 DtimepenS_A_3 DtimepenS_A_4 DtimepenS_A_2Xfemale DtimepenS_A_3Xfemale DtimepenS_A_4Xfemale female $XVARNOGENDER, cluster(gruppo) 
est store pen_4

* Check wealth
reg ex_gov_age_incr i.timeS_reform_age_incr_A##c.deavg_log_hnetw $XVAR, cluster(gruppo) 
reg ex_gov_red_pen i.timeS_reform_red_pen_A##c.deavg_log_hnetw $XVAR, cluster(gruppo) 

/* TABLE 8 PANEL A */
esttab age_1 age_2 age_3 age_4 using "$output/table8.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*4.dm_education* *Xuniv* avg_numeracy *#c.avg_numeracy* rage *Xage* *female*) order(*4.dm_education* *Xuniv* avg_numeracy *#c.avg_numeracy* rage *Xage* female *Xfeamle*)  ///
	starlevels(* .10 ** .05 *** .01) title("Panel A, BNRA") ///
	nogaps replace

esttab pen_1 pen_2 pen_3 pen_4 using "$output/table8.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*4.dm_education* *Xuniv* avg_numeracy *#c.avg_numeracy* rage *Xage* *female*) order(*4.dm_education* *Xuniv* avg_numeracy *#c.avg_numeracy* rage *Xage* female *Xfeamle*) ///
	starlevels(* .10 ** .05 *** .01) title("Panel A, BPB")  ///
	nogaps append

replace google6=google6/100
	
foreach var in age_incr red_pen {

	reg ex_gov_`var' c.google6 c.google6#i.univ i.dm_education $XVAR3, cluster(gruppo) 
	est store `var'_1
		
	reg ex_gov_`var' c.google6 c.google6#c.avg_numeracy avg_numeracy $XVAR3, cluster(gruppo) 
	est store `var'_2
	
	reg ex_gov_`var' c.google6 c.google6#c.rage c.rage $XVARNOAGE, cluster(gruppo) 
	est store `var'_3
	
	reg ex_gov_`var' c.google6 c.google6#i.female female $XVARNOGENDER, cluster(gruppo)
	est store `var'_4

	* check wealth
	reg ex_gov_`var' c.google6 c.google6#c.deavg_log_hnetw $XVAR, cluster(gruppo)

	}

/* TABLE 8 PANEL B */

esttab age_incr_1 age_incr_2 age_incr_3 age_incr_4 using "$output/table8.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*4.dm_education* *univ#* avg_numeracy *#c.avg_numeracy* rage *#c.rage* female *female#*) order(*4.dm_education* *univ#* avg_numeracy *#c.avg_numeracy* rage *#c.rage* female *female#*) ///
	starlevels(* .10 ** .05 *** .01) title("Panel B, BNRA")  ///
	nogaps append

esttab red_pen_1 red_pen_2 red_pen_3 red_pen_4 using "$output/table8.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*4.dm_education* *univ#* avg_numeracy *#c.avg_numeracy* rage *#c.rage* female *female#*) order(*4.dm_education* *univ#* avg_numeracy *#c.avg_numeracy* rage *#c.rage* female *female#*)  ///
	starlevels(* .10 ** .05 *** .01) title("Panel B, BPB")  ///
	nogaps append


*********************
* CONVERGENCE		*
*********************	
use reforms, clear
keep if samplesel==1

g mm=dm_numeracy>=1 & dm_numeracy<=5
egen tmm=sum(mm), by(pid)
tab tmm
egen avg_numeracy=mean(dm_numeracy), by(pid)

sum avg_numeracy, d
replace avg_numeracy=avg_numeracy-r(mean)

* Variance
quietly reg ex_gov_age_incr i.timeS_reform_age_incr $XVAR, cluster(gruppo)
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_age_incr $XVAR, cluster(gruppo) small partial($XVAR)
est store variance_age
drop res res2

quietly reg ex_gov_red_pen i.timeS_reform_red_pen $XVAR, cluster(gruppo)
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_red_pen $XVAR, cluster(gruppo) small partial($XVAR)
est store variance_pen
drop res res2

quietly reg ex_gov_age_incr i.timeS_reform_age_incr_A  $XVAR, cluster(gruppo)
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_age_incr_A  $XVAR, cluster(gruppo) small partial($XVAR)
est store variance_age_A
drop res res2

quietly reg ex_gov_red_pen i.timeS_reform_red_pen_A $XVAR, cluster(gruppo)
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_red_pen_A $XVAR, cluster(gruppo) small partial($XVAR)
est store variance_pen_A
drop res res2

* variance after full reg
* i.timeS_reform_red_pen_A#c.dist_NRA dist_NRA
g univ=dm_education==4
tab dm_education, g(Ddm_education)

g female=dm_gender==2

tab timeS_reform_age_incr, g(DtimeageS_)
g DtimeageS_2Xuniv=DtimeageS_2*univ
g DtimeageS_3Xuniv=DtimeageS_3*univ
g DtimeageS_2Xage=DtimeageS_2*(dm_age_years-50)
g DtimeageS_3Xage=DtimeageS_3*(dm_age_years-50)
g DtimeageS_2Xfemale=DtimeageS_2*female
g DtimeageS_3Xfemale=DtimeageS_3*female

tab timeS_reform_red_pen, g(DtimepenS_)
g DtimepenS_2Xuniv=DtimepenS_2*univ
g DtimepenS_3Xuniv=DtimepenS_3*univ
g DtimepenS_2Xage=DtimepenS_2*(dm_age_years-50)
g DtimepenS_3Xage=DtimepenS_3*(dm_age_years-50)
g DtimepenS_2Xfemale=DtimepenS_2*female
g DtimepenS_3Xfemale=DtimepenS_3*female

tab timeS_reform_age_incr_A, g(DtimeageS_A_)
g DtimeageS_A_2Xuniv=DtimeageS_A_2*univ
g DtimeageS_A_3Xuniv=DtimeageS_A_3*univ
g DtimeageS_A_4Xuniv=DtimeageS_A_4*univ
g DtimeageS_A_2Xage=DtimeageS_A_2*(dm_age_years-50)
g DtimeageS_A_3Xage=DtimeageS_A_3*(dm_age_years-50)
g DtimeageS_A_4Xage=DtimeageS_A_4*(dm_age_years-50)
g DtimeageS_A_2Xfemale=DtimeageS_A_2*female
g DtimeageS_A_3Xfemale=DtimeageS_A_3*female
g DtimeageS_A_4Xfemale=DtimeageS_A_4*female

tab timeS_reform_red_pen_A, g(DtimepenS_A_)
g DtimepenS_A_2Xuniv=DtimepenS_A_2*univ
g DtimepenS_A_3Xuniv=DtimepenS_A_3*univ
g DtimepenS_A_4Xuniv=DtimepenS_A_4*univ
g DtimepenS_A_2Xage=DtimepenS_A_2*(dm_age_years-50)
g DtimepenS_A_3Xage=DtimepenS_A_3*(dm_age_years-50)
g DtimepenS_A_4Xage=DtimepenS_A_4*(dm_age_years-50)
g DtimepenS_A_2Xfemale=DtimepenS_A_2*female
g DtimepenS_A_3Xfemale=DtimepenS_A_3*female
g DtimepenS_A_4Xfemale=DtimepenS_A_4*female

reg ex_gov_age_incr i.timeS_reform_age_incr DtimeageS_2Xuniv DtimeageS_3Xuniv ///
	DtimeageS_2Xage DtimeageS_3Xage DtimeageS_2Xfemale DtimeageS_3Xfemale $XVAR, cluster(gruppo)  
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_age_incr $XVAR, cluster(gruppo) small partial($XVAR)
est store Fvariance_age
drop res res2

reg ex_gov_red_pen i.timeS_reform_red_pen DtimepenS_2Xuniv DtimepenS_3Xuniv ///
	DtimepenS_2Xage DtimepenS_3Xage DtimepenS_2Xfemale DtimepenS_3Xfemale $XVAR, cluster(gruppo)  
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_red_pen $XVAR, cluster(gruppo) small partial($XVAR)
est store Fvariance_pen
drop res res2

reg ex_gov_age_incr i.timeS_reform_age_incr_A DtimeageS_A_2Xuniv DtimeageS_A_3Xuniv DtimeageS_A_4Xuniv ///
	DtimeageS_A_2Xage DtimeageS_A_3Xage DtimeageS_A_4Xage DtimeageS_A_2Xfemale DtimeageS_A_3Xfemale DtimeageS_A_4Xfemale $XVAR, cluster(gruppo)  
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_age_incr_A $XVAR, cluster(gruppo) small partial($XVAR)
est store Fvariance_age_A
drop res res2

reg ex_gov_red_pen i.timeS_reform_red_pen_A DtimepenS_A_2Xuniv DtimepenS_A_3Xuniv DtimepenS_A_4Xuniv ///
	DtimepenS_A_2Xage DtimepenS_A_3Xage DtimepenS_A_4Xage DtimepenS_A_2Xfemale DtimepenS_A_3Xfemale DtimepenS_A_4Xfemale $XVAR, cluster(gruppo)  
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_red_pen_A $XVAR, cluster(gruppo) small partial($XVAR)
est store Fvariance_pen_A
drop res res2

/* TABLE 9 */

esttab variance_age variance_pen Fvariance_age Fvariance_pen using "$output/table9.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(_Itime*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel A") ///
	nogaps replace
	
esttab variance_age_A variance_pen_A Fvariance_age_A Fvariance_pen_A using "$output/table9.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(_Itime*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel B") ///
	nogaps append
	
* Check footnote 31
reg ex_gov_age_incr i.timeS_reform_age_incr DtimeageS_2Xuniv DtimeageS_3Xuniv ///
	DtimeageS_2Xage DtimeageS_3Xage DtimeageS_2Xfemale DtimeageS_3Xfemale i.timeS_reform_age_incr#c.avg_numeracy $XVAR, cluster(gruppo)  
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_age_incr $XVAR, cluster(gruppo) small partial($XVAR)
est store Fvariance_age
drop res res2

reg ex_gov_red_pen i.timeS_reform_red_pen DtimepenS_2Xuniv DtimepenS_3Xuniv ///
	DtimepenS_2Xage DtimepenS_3Xage DtimepenS_2Xfemale DtimepenS_3Xfemale i.timeS_reform_red_pen#c.avg_numeracy $XVAR, cluster(gruppo)  
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_red_pen $XVAR, cluster(gruppo) small partial($XVAR)
est store Fvariance_pen
drop res res2

reg ex_gov_age_incr i.timeS_reform_age_incr_A DtimeageS_A_2Xuniv DtimeageS_A_3Xuniv DtimeageS_A_4Xuniv ///
	DtimeageS_A_2Xage DtimeageS_A_3Xage DtimeageS_A_4Xage DtimeageS_A_2Xfemale DtimeageS_A_3Xfemale DtimeageS_A_4Xfemale $XVAR ///
	i.timeS_reform_age_incr_A#c.avg_numeracy, cluster(gruppo)  
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_age_incr_A $XVAR, cluster(gruppo) small partial($XVAR)
est store Fvariance_age_A
drop res res2

reg ex_gov_red_pen i.timeS_reform_red_pen_A DtimepenS_A_2Xuniv DtimepenS_A_3Xuniv DtimepenS_A_4Xuniv ///
	DtimepenS_A_2Xage DtimepenS_A_3Xage DtimepenS_A_4Xage DtimepenS_A_2Xfemale DtimepenS_A_3Xfemale DtimepenS_A_4Xfemale $XVAR ///
	i.timeS_reform_red_pen_A#c.avg_numeracy, cluster(gruppo)  
predict res, res
g res2=res^2
xi: ivreg2 res2 i.timeS_reform_red_pen_A $XVAR, cluster(gruppo) small partial($XVAR)
est store Fvariance_pen_A
drop res res2

esttab variance_age variance_pen Fvariance_age Fvariance_pen using "$output/footnote31_numeracy.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(_Itime*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel A") ///
	nogaps replace
	
esttab variance_age_A variance_pen_A Fvariance_age_A Fvariance_pen_A using "$output/footnote31_numeracy.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(_Itime*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel B") ///
	nogaps append

****************
* EVENT STUDY  *
****************

use reforms, clear
keep if samplesel==1

foreach v in age_incr red_pen {
	recode to_reform_`v' from_reform_`v' (0=.)
	replace to_reform_`v'=to_reform_`v'-1
	replace from_reform_`v'=from_reform_`v'-1
	g event_time_`v'=-to_reform_`v' if abs(to_reform_`v')<abs(from_reform_`v')
	replace event_time_`v'=from_reform_`v' if abs(to_reform_`v')>=abs(from_reform_`v')
	replace event_time_`v'=-25 if event_time_`v'<=-25
	replace event_time_`v'=25 if event_time_`v'>=25
	g _event_time_`v'=event_time_`v'
	replace _event_time_`v'=_event_time_`v'-1 if _event_time_`v'>0
	g Qevent_time_`v'=floor(_event_time_`v'/6)
	replace Qevent_time_`v'=4 if event_time_`v'>=25
}

table Qevent_time_age_incr, c(min event_time_age_incr max event_time_age_incr)

/* FIGURE 5 */

*main estimates graph, full reg
foreach var in age_incr red_pen {
	preserve
		if "`var'"=="age_incr" {
			local y="BNRA"	
			local let="a"
			}
		else {
			local y="BPB"
			local let="c"
			}
		reg ex_gov_`var' b0.timeS_reform_`var' $XVAR, cluster(gruppo)
		collapse (mean) ex_gov_`var', by(timeS_reform_`var')
		g b=0
		g b_up=0
		g b_down=0
		forvalues i=1(1)2 {
			capture replace b=_b[`i'.timeS_reform_`var'] if timeS_reform_`var'==`i'
			capture replace b_down=_b[`i'.timeS_reform_`var']-1.96*_se[`i'.timeS_reform_`var'] if timeS_reform_`var'==`i'
			capture replace b_up=_b[`i'.timeS_reform_`var']+1.96*_se[`i'.timeS_reform_`var'] if timeS_reform_`var'==`i'
		}
		list
		*replace timeS_reform_`var'=(timeS_reform_`var')
		graph twoway (scatter b timeS_reform_`var') ///
			(rcap b_up b_down timeS_reform_`var'), xscale(range(-.5 +2.5)) yscale(range(-.2 +.2)) ///
			xlabel(0 "<-12 or >12" 1 "[-12,-1]" 2 "[0,12]", labsize(small)) ylabel(-.2(.1).2) ///
			xtitle("Distance in months from the reforms") ytitle("`y'") ///
			legend(label(1 "Difference w.r.t. 12 months away from any reform (<-12 or >12)") label(2 "95% c.i.") rows(2))
		graph export "$output/figure_5`let'.png", as(png) width(1200) replace
	restore
}

* semester graph, adjustment, full reg
foreach var in age_incr red_pen {
	preserve
		if "`var'"=="age_incr" {
			local y="BNRA"		
			local let="b"
			}
		else {
			local y="BPB"
			local let="d"
			}
		replace Qevent_time_`var'=-5 if Qevent_time_`var'==4
		replace Qevent_time_`var'=Qevent_time_`var'+5
		reg ex_gov_`var' b0.Qevent_time_`var' $XVAR, cluster(gruppo)
		collapse (mean) ex_gov_`var', by(Qevent_time_`var')
		g b=0
		g b_up=0
		g b_down=0
		forvalues i=0(1)9 {
			capture replace b=_b[`i'.Qevent_time_`var'] if Qevent_time_`var'==`i'
			capture replace b_down=_b[`i'.Qevent_time_`var']-1.96*_se[`i'.Qevent_time_`var'] if Qevent_time_`var'==`i'
			capture replace b_up=_b[`i'.Qevent_time_`var']+1.96*_se[`i'.Qevent_time_`var'] if Qevent_time_`var'==`i'
		}
		list
		replace Qevent_time_`var'=(Qevent_time_`var'-5)*3
		graph twoway (scatter b Qevent_time_`var') ///
			(rcap b_up b_down Qevent_time_`var'), xline(0, lcolor(gs15)) xscale(range(-16 +10)) yscale(range(-.2 +.2)) ///
			xlabel(-15 "<-24 or >24" -12 "[-24,-19]" -9 "[-18,-13]" -6 "[-12,-7]" -3 "[-6,-1]" 0 "[0,6]" 3 "[7,12]" ///
			6 "[13,18]" 9 "[19,24]", labsize(small)) ylabel(-.2(.1).2) ///
			xtitle("Distance in months from the reforms") ytitle("`y'") ///
			legend(label(1 "Difference w.r.t. 24 months away from any reform (<-24 or >24)") label(2 "95% c.i.") rows(2))
		graph export "$output/figure_5`let'.png", as(png) width(1200) replace
	restore
}
	
	
******************************
* FRACLOGIT					 *
******************************

use reforms, clear
keep if samplesel==1

tab timeS_reform_age_incr_A
tab timeS_reform_red_pen_A

replace google6=google6/100

* fraclogit
fracreg logit ex_gov_age_incr i.timeS_reform_age_incr $XVAR, vce(cluster gruppo)	
margins, dydx(timeS_reform_age_incr) post
est store frac_age
fracreg logit ex_gov_red_pen i.timeS_reform_red_pen $XVAR, vce(cluster gruppo)
margins, dydx(timeS_reform_red_pen) post
est store frac_pen

fracreg logit ex_gov_age_incr i.timeS_reform_age_incr_A $XVAR, vce(cluster gruppo)	
margins, dydx(timeS_reform_age_incr_A) post
est store fracA_age
fracreg logit ex_gov_red_pen i.timeS_reform_red_pen_A $XVAR, vce(cluster gruppo)
margins, dydx(timeS_reform_red_pen_A) post
est store fracA_pen

fracreg logit ex_gov_age_incr c.google6 $XVAR, vce(cluster gruppo)	
margins, dydx(google6) post
est store frac_age_GT
fracreg logit ex_gov_red_pen c.google6 $XVAR, vce(cluster gruppo)
margins, dydx(google6) post
est store frac_pen_GT

fracreg logit ex_gov_age_incr c.news_nexis_rescmax6 $XVAR, vce(cluster gruppo)	
margins, dydx(news_nexis_rescmax6) post
est store frac_age_news
fracreg logit ex_gov_red_pen c.news_nexis_rescmax6 $XVAR, vce(cluster gruppo)
margins, dydx(news_nexis_rescmax6) post
est store frac_pen_news
	
/* TABLE A_6 */

esttab frac_age frac_pen using "$output/tableA_6.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel A") ///
	nogaps replace	

esttab fracA_age fracA_pen using "$output/tableA_6.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel B") ///
	nogaps append	
	
esttab frac_age_GT frac_pen_GT using "$output/tableA_6.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*google6*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel C") ///
	nogaps append
	
esttab frac_age_news frac_pen_news using "$output/tableA_6.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*news*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel D") ///
	nogaps append

****************************
* CHECK: UNDER 60		   *
****************************
use reforms, clear
keep if samplesel==1

tab timeS_reform_age_incr if dm_age_years<60
tab timeS_reform_red_pen if dm_age_years<60

xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr $XVAR if dm_age_years<60, cluster(gruppo) small partial(i.tempo)
est store blockS_age
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen $XVAR if dm_age_years<60, cluster(gruppo) small partial(i.tempo)
est store blockS_pen

/* TABLE A.7 Panel A */

esttab blockS_age blockS_pen using "$output/tableA_7.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel A") ///
	nogaps replace
	
*****************************
* CHECK: COUNTRY GROUP		*
*****************************
use reforms, clear
keep if samplesel==1

g southern=country==15|country==16

regress ex_gov_age_incr i.timeS_reform_age_incr i1.timeS_reform_age_incr#i.southern i2.timeS_reform_age_incr#i.southern $XVAR, cluster(gruppo) 
est store blockS_age
regress ex_gov_red_pen i.timeS_reform_red_pen i1.timeS_reform_red_pen#i.southern i2.timeS_reform_red_pen#i.southern $XVAR, cluster(gruppo) 
est store blockS_pen

/* TABLE A.7 Panel B*/
esttab blockS_age blockS_pen using "$output/tableA_7.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel B") ///
	nogaps append

*********************************
* CHECK: DIFFERENT TIME WINDOWS *
*********************************
use reforms, clear
keep if samplesel==1

xi: ivreg2 ex_gov_age_incr i.timeS6_reform_age_incr $XVAR, cluster(gruppo) small partial(i.tempo)
est store dummy_age
xi: ivreg2 ex_gov_red_pen i.timeS6_reform_red_pen $XVAR, cluster(gruppo) small partial(i.tempo)
est store dummy_pen

xi: ivreg2 ex_gov_age_incr i.timeS18_reform_age_incr $XVAR, cluster(gruppo) small partial(i.tempo)
est store blockS18_age
xi: ivreg2 ex_gov_red_pen i.timeS18_reform_red_pen $XVAR, cluster(gruppo) small partial(i.tempo)
est store blockS18_pen

/* TABLE A.8 Panels A and B */
esttab dummy_age dummy_pen using "$output/tableA_8.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS6*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel A") ///
	nogaps replace

esttab blockS18_age blockS18_pen using "$output/tableA_8.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(_Itime*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel B") ///
	nogaps append	
	
* Table A.8 averages of I(.,.) indicators
sum i.timeS6_reform_age_incr i.timeS6_reform_red_pen i.timeS18_reform_age_incr i.timeS18_reform_red_pen

**********************************************
* CHECK: DIFFERENT TIME WINDOWS ANNOUNCEMENT *
**********************************************
use reforms, clear
keep if samplesel==1

xi: ivreg2 ex_gov_age_incr i.timeS6_reform_age_incr_A $XVAR, cluster(gruppo) small partial($XVAR)
est store dummy_age
xi: ivreg2 ex_gov_red_pen i.timeS6_reform_red_pen_A $XVAR, cluster(gruppo) small partial($XVAR)
est store dummy_pen

xi: ivreg2 ex_gov_age_incr i.timeS18_reform_age_incr_A $XVAR, cluster(gruppo) small partial($XVAR)
est store blockS18_age
xi: ivreg2 ex_gov_red_pen i.timeS18_reform_red_pen_A $XVAR, cluster(gruppo) small partial($XVAR)
est store blockS18_pen

/* TABLE A.8 Panels C and D */
esttab dummy_age dummy_pen using "$output/tableA_8.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS6*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel C") ///
	nogaps append

esttab blockS18_age blockS18_pen using "$output/tableA_8.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(_Itime*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel D") ///
	nogaps append		

* Table A.8 averages of I(.,.) indicators
sum i.timeS6_reform_age_incr_A i.timeS6_reform_red_pen_A i.timeS18_reform_age_incr_A i.timeS18_reform_red_pen_A
	
************************
* CHECK: CROSS-EFFECTS *
************************
use reforms, clear
keep if samplesel==1

reg ex_gov_age_incr i.timeS_reform_age_incr i.timeS_reform_red_pen $XVAR, cluster(gruppo)
est store cross_age
reg ex_gov_red_pen i.timeS_reform_age_incr i.timeS_reform_red_pen $XVAR, cluster(gruppo)
est store cross_pen

reg ex_gov_age_incr i.timeS_reform_age_incr#i.timeS_reform_red_pen $XVAR, cluster(gruppo)
est store crossF_age
reg ex_gov_red_pen i.timeS_reform_age_incr#i.timeS_reform_red_pen $XVAR, cluster(gruppo)
est store crossF_pen

/* TABLE A.9 */
esttab cross_age cross_pen using "$output/tableA_9.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel A") ///
	nogaps replace
	
esttab crossF_age crossF_pen using "$output/tableA_9.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel B") ///
	nogaps append
	
*************************************************
* CHECKS: GOOGLE TRENDS							*
*************************************************
use reforms, clear
keep if samplesel==1

replace google=google/100
replace google6=google6/100

replace internet_access_pctpop=internet_access_pctpop/100

replace austerity6=austerity6/100

replace other_reforms6=other_reforms6/100

xi: ivreg2 ex_gov_age_incr google $XVAR, cluster(gruppo) small partial($XVAR)
est store google0_age
xi: ivreg2 ex_gov_red_pen google $XVAR, cluster(gruppo) small partial($XVAR)
est store google0_pen

xi: ivreg2 ex_gov_age_incr google6 austerity6 $XVAR, cluster(gruppo) small partial($XVAR)
est store googleaust_age
xi: ivreg2 ex_gov_red_pen google6 austerity6 $XVAR, cluster(gruppo) small partial($XVAR)
est store googleaust_pen

xi: ivreg2 ex_gov_age_incr google6 other_reforms6 $XVAR, cluster(gruppo) small partial($XVAR)
est store googleoth_age
xi: ivreg2 ex_gov_red_pen google6 other_reforms6 $XVAR, cluster(gruppo) small partial($XVAR)
est store googleoth_pen

xi: ivreg2 ex_gov_age_incr google6 internet_access_pctpop $XVAR, cluster(gruppo) small partial($XVAR)
est store googleinternet_age
xi: ivreg2 ex_gov_red_pen google6 internet_access_pctpop $XVAR, cluster(gruppo) small partial($XVAR)
est store googleinternet_pen

/* TABLE A.11 */

esttab google0_age google0_pen using "$output/tableA_11.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*google*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel A") ///
	nogaps replace	
	
esttab googleaust_age googleaust_pen using "$output/tableA_11.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*google* *aust*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel B") ///
	nogaps append	
	
esttab googleoth_age googleoth_pen using "$output/tableA_11.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*google* *other*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel C") ///
	nogaps append	
	
esttab googleinternet_age googleinternet_pen using "$output/tableA_11.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*google* *internet*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel D") ///
	nogaps append	

* Table A.11 averages for covariates
sum google 
sum google6 austerity6 other_reforms6 internet_access_pctpop if google6!=.

*************************************************************
* CHECK: CORRELATION BETWEEN CUE AND INFO ACQUISITION		*
*************************************************************

use reforms, clear
keep if samplesel==1

g r=read==1 | internet==1
g r2=read==1 & internet==1

replace r=. if read==. | internet==.
replace r2=. if read==. | internet==.

g mm=dm_numeracy>=1 & dm_numeracy<=5
egen tmm=sum(mm), by(pid)
tab tmm
egen avg_numeracy=mean(dm_numeracy), by(pid)

sum avg_numeracy, d
replace avg_numeracy=avg_numeracy-r(mean)

g univ=dm_education==4

tab dm_education, g(Ddm_education)

g rage=(dm_age_years-50)

g female=dm_gender==2

reg r $XVAR, cluster(gruppo) 
est store A
reg r avg_numeracy $XVAR3, cluster(gruppo) 
est store B
reg r c.rage $XVARNOAGE, cluster(gruppo)
est store C
reg r female $XVARNOGENDER, cluster(gruppo) 
est store D

reg read $XVAR, cluster(gruppo) 
est store A_1
reg read avg_numeracy $XVAR3, cluster(gruppo) 
est store B_1
reg read c.rage $XVARNOAGE, cluster(gruppo) 
est store C_1
reg read female $XVARNOGENDER, cluster(gruppo)
est store D_1

reg internet $XVAR, cluster(gruppo) 
est store A_2
reg internet avg_numeracy $XVAR3, cluster(gruppo) 
est store B_2
reg internet c.rage $XVARNOAGE, cluster(gruppo) 
est store C_2
reg internet female $XVARNOGENDER, cluster(gruppo) 
est store D_2

/* TABLE footnote 28 */

esttab A B C D using "$output/table_footnote_28.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*dm_edu* *avg_num* *rage* *female*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	nogaps append

esttab A_1 B_1 C_1 D_1 using "$output/table_footnote_28.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*dm_edu* *avg_num* *rage* *female*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	nogaps append
	
esttab A_2 B_2 C_2 D_2 using "$output/table_footnote_28.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*dm_edu* *avg_num* *rage* *female*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	nogaps append
	
*************************************************
* CHECK: EFFECT BY PRIOR BELIEFS				*
*************************************************

use reforms, clear
replace wave=wave-1 if wave>=4
xtset pid wave

g l_ex_gov_age_incr=l.ex_gov_age_incr
g l_ex_gov_red_pen=l.ex_gov_red_pen

keep if samplesel==1

foreach var in age_incr red_pen {
	g l_ex_gov_`var'_r=l_ex_gov_`var'
	replace l_ex_gov_`var'_r=0 if l_ex_gov_`var'<.20
	replace l_ex_gov_`var'_r=1 if l_ex_gov_`var'>=.20 & l_ex_gov_`var'<.40
	replace l_ex_gov_`var'_r=2 if l_ex_gov_`var'>=.40 & l_ex_gov_`var'<.60
	replace l_ex_gov_`var'_r=3 if l_ex_gov_`var'>=.60 & l_ex_gov_`var'<.80
	replace l_ex_gov_`var'_r=4 if l_ex_gov_`var'>=.80 & l_ex_gov_`var'<=1
	table l_ex_gov_`var'_r, c(min l_ex_gov_`var' max l_ex_gov_`var')
}

g ex_gov_red_pen_r=ex_gov_red_pen	
replace ex_gov_red_pen_r=ex_gov_red_pen_r*10
tab ex_gov_red_pen_r
replace ex_gov_red_pen_r=round(ex_gov_red_pen_r)
tab ex_gov_red_pen_r

reg ex_gov_age_incr i.timeS_reform_age_incr##i.l_ex_gov_age_incr_r i.l_ex_gov_age_incr_r $XVAR, cluster(gruppo)
margins, dydx(timeS_reform_age_incr) at(l_ex_gov_age_incr_r=(0(1)4)) post

g b_im12m1_nra=.
g se_im12m1_nra=.
g b_i012_nra=.
g se_i012_nra=.

forvalues i=1(1)5 {
	replace b_im12m1_nra=_b[1.timeS_reform_age_incr:`i'._at] if _n==`i'
	replace se_im12m1_nra=_se[1.timeS_reform_age_incr:`i'._at] if _n==`i'
	replace b_i012_nra=_b[2.timeS_reform_age_incr:`i'._at] if _n==`i'
	replace se_i012_nra=_se[2.timeS_reform_age_incr:`i'._at] if _n==`i'
	}

reg ex_gov_red_pen i.timeS_reform_red_pen##i.l_ex_gov_red_pen_r i.l_ex_gov_red_pen_r $XVAR, cluster(gruppo)
margins, dydx(timeS_reform_red_pen) at(l_ex_gov_red_pen_r=(0(1)4)) post

g b_im12m1_pb=.
g se_im12m1_pb=.

forvalues i=1(1)5 {
	replace b_im12m1_pb=_b[1.timeS_reform_red_pen:`i'._at] if _n==`i'
	replace se_im12m1_pb=_se[1.timeS_reform_red_pen:`i'._at] if _n==`i'
	}
	
g lagged_beliefs=_n
	
/* FIGURE A.6*/
keep if lagged_beliefs<=5

label define lagged_beliefs 1 "[0.0,0.2)" 2 "[0.2,0.4)" 3 "[0.4,0.6)" 4 "[0.6,0.8)" 5 "[0.8,1.0]"
label values lagged_belief lagged_beliefs

g b_im12m1_nra_up=b_im12m1_nra+1.96*se_im12m1_nra
g b_im12m1_nra_down=b_im12m1_nra-1.96*se_im12m1_nra

g b_i012_nra_up=b_i012_nra+1.96*se_i012_nra
g b_i012_nra_down=b_i012_nra-1.96*se_i012_nra

graph twoway (rarea b_im12m1_nra_up b_im12m1_nra_down lagged_belief, lwidth(none) fcolor(blue) fintensity(20)) (line b_im12m1_nra lagged_belief, lwidth(medium) lcolor(blue)), ///
	xtitle("Lagged belief") xlabel(,valuelabel) legend(off) title("Marginal effect of I(-12,-1)") name(BNRA1, replace)
	
graph twoway (rarea b_i012_nra_up b_i012_nra_down lagged_belief, lwidth(none) fcolor(red) fintensity(20)) (line b_i012_nra lagged_belief, lwidth(medium) lcolor(red)), ///
	xtitle("Lagged belief") xlabel(,valuelabel) legend(off) title("Marginal effect of I(0,12)") name(BNRA2, replace)

graph combine BNRA1 BNRA2, rows(2) ycommon
graph export "$output/figure_A6a.png", width(1200) as(png) replace

g b_im12m1_pb_up=b_im12m1_pb+1.96*se_im12m1_pb
g b_im12m1_pb_down=b_im12m1_pb-1.96*se_im12m1_pb

graph twoway (rarea b_im12m1_pb_up b_im12m1_pb_down lagged_belief, lwidth(none) fcolor(blue) fintensity(20)) (line b_im12m1_pb lagged_belief, lwidth(medium) lcolor(blue)), ///
	xtitle("Lagged belief", size(vlarge)) yscale(range(-.2 .25)) ylabel(-.2(.1).2, labsize(vlarge)) ysize(2) xlabel(,valuelabel labsize(vlarge)) legend(off) title("Marginal effect of I(-12,-1)",size(huge)) name(Bpb1, replace)
	
graph export "$output/figure_A6b.png", width(1200) as(png) replace


*********************************
* CHECK: LEAVE ONE COUNTRY OUT  *
*********************************
use reforms, clear
keep if samplesel==1

foreach cc in 11 12 13 14 15 16 17 18 20 23 {
	quietly xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr $XVAR if country!=`cc', cluster(gruppo) small partial($XVAR)
	est store blockS_age_`cc'
	quietly xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen $XVAR if country!=`cc', cluster(gruppo) small partial($XVAR)
	est store blockS_pen_`cc'
	}
	
/* TABLE A_1 */

esttab blockS_age_11 blockS_age_12 blockS_age_13 blockS_age_14 blockS_age_15 blockS_age_16 blockS_age_17 ///
		blockS_age_18 blockS_age_20 blockS_age_23 using "$output/tableA_1.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(_Itime*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("11" "12" "13" "14" "15" "16" "17" "18" "20" "23") ///
	nogaps replace
	
esttab blockS_pen_11 blockS_pen_12 blockS_pen_13 blockS_pen_14 blockS_pen_15 blockS_pen_16 blockS_pen_17 ///
		blockS_pen_18 blockS_pen_20 blockS_pen_23 using "$output/tableA_1.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(_Itime*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("11" "12" "13" "14" "15" "16" "17" "18" "20" "23") ///
	nogaps append
		
	
*************************
* ADDITIONAL CHECKS		*
*************************
use reforms, clear
keep if samplesel==1

xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr left_right caretaker D_to_change_gov D_to_elections $XVAR, cluster(gruppo) small partial($XVAR)
est store election_ageincr
 
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen left_right caretaker D_to_change_gov D_to_elections $XVAR, cluster(gruppo) small partial($XVAR)
est store election_redpen

/*TABLE A.2*/

esttab election_ageincr election_redpen using "$output/tableA_2.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS* left_right caretaker D_to_change_gov D_to_elections) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel A: time to elections") ///
	nogaps replace
	
preserve
	use reforms, clear

	xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr $XVAR, cluster(gruppo) small partial($XVAR)
	est store rob_ageincr
	 
	xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen $XVAR, cluster(gruppo) small partial($XVAR)
	est store rob_redpen

	esttab rob_ageincr rob_redpen using "$output/tableA_2.csv", /// 		
		b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
		starlevels(* .10 ** .05 *** .01)   ///
		mtitles("Chances age incr" "Chances red pen") title("Panel B: without dropping cells <30 obs") ///
		nogaps append
restore
	
egen gruppo2=group(country int_year)

xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr $XVARNOT, cluster(gruppo2) partial(i.int_year)
est store rob2_ageincr
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen $XVARNOT, cluster(gruppo2) partial(i.int_year)
est store rob2_redpen

esttab rob2_ageincr rob2_redpen using "$output/tableA_2.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel C: with only year dummies (instead of month of interview)") ///
	nogaps append

* check alternative def
xi: ivreg2 ex_gov_age_incr timeS_reform_age_incrD1-timeS_reform_age_incrD2 $XVAR, cluster(gruppo) small partial(i.tempo)
est store rob3_ageincr
xi: ivreg2 ex_gov_red_pen timeS_reform_red_penD1-timeS_reform_red_penD2 $XVAR, cluster(gruppo) small partial(i.tempo)
est store rob3_redpen

esttab rob3_ageincr rob3_redpen using "$output/tableA_2.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel D: dummies defined not as mutually exclusive") ///
	nogaps append
	
*	beforePB 11 Austria 2007m1 is within one year before a reform that halved the discount rate for early retirement (backtracking of previous reforms)
*	beforeNRA 17 France 2005m6 m7 are within one year before a reform that reduced retirement age (June and Dec 2006 relaxed conditions for accessing the gradual retirement facility)
*   beforeNRA 17 France 2006m11 are within one year before a reform that reduced retirement age (June and Dec 2006 relaxed conditions for accessing the gradual retirement facility)
*   afterNRA 17 France 2006m12 2007m1 are within one year after a reform that reduced retirement age (June and Dec 2006 relaxed conditions for accessing the gradual retirement facility)
*   beforeNRA 17 France 2011m6-2011m8 are within one year before a refore tha reduced retirement age (June 2012 brought back NRA to 60 for some those who started early to work)
*	afterNRA 17 France 2013m3-m6 (m4-m6 close to the following Jan 2014 reform) are within one year after a reform that reduced retirement age (June 2012 brought back NRA to 60 for some those who started early to work)
*	beforeNRA beforePB 12 Germany 2013m7-m9 are within 1 year before a reform that reduced NRA and increased benefits (July 2014)
*	beforeNRA beforePB 16 Italy 2007 (m1-m4) is within one year before an increase in PB (December 2007 reduction in NRA, they reduced the pace of increase decided in earlier reforms)
*	afterPB 15 Spain 2004 (m6-m12) are within one year after an increase in PB (Jan 20014, stronger revaluation of minimum contributory and non-contributory pensions)

g opposite=(country==11 & (int_year==2007 & int_month==1)) | ///
		(country==17 & (int_year==2005 & int_month>=6 & int_month<=7)) | ///
		(country==17 & (int_year==2006 & int_month==11)) | ///
		(country==17 & (int_year==2006 & int_month==12)) | (country==17 & (int_year==2007 & int_month==1)) | ///
		(country==17 & (int_year==2011 & int_month>=6 & int_month<=8)) | ///
		(country==17 & (int_year==2013 & int_month>=3 & int_month<=6)) | ///
		(country==12 & (int_year==2013 & int_month>=7 & int_month<=9)) | ///
		(country==16 & (int_year==2007 & int_month>=1 & int_mont<=4)) | ///
		(country==15 & (int_year==2004 & int_month>=6 & int_month<=12))
g _opposite=opposite

tab opposite timeS_reform_age_incr
tab opposite timeS_reform_red_pen

tab tempo country if opposite==1 & timeS_reform_age_incr==1
tab tempo country if opposite==1 & timeS_reform_red_pen==1

* France 2011m6-2011m8 is actually before the December 2011 reform that accelerated the increase in NRA
* The change in government occured only in May 2012 
* Hence we do not consider it
replace opposite=0 if (country==17 & (int_year==2011 & int_month>=6 & int_month<=8))	
* France 2013m4-2011m6 is actually closer (less than 10 months) 
* from the January 2014 reform
replace opposite=0 if (country==17 & (int_year==2013 & int_month>=4 & int_month<=6))
		
tab country int_year if timeS_reform_age_incr==1 & opposite==1
tab country int_year if timeS_reform_red_pen==1 & opposite==1
table tempo if country==17, c(mean timeS_reform_age_incr mean opposite)

xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr i.opposite $XVAR, cluster(gruppo) small partial($XVAR)
est store rob4_ageincr

xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen i.opposite $XVAR, cluster(gruppo) small partial($XVAR)
est store rob4_redpen

esttab rob4_ageincr rob4_redpen using "$output/tableA_2.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS* *opposite*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel E: controlling for opposite reforms") ///
	nogaps append
	
g dist_NRA=NRA-dm_age_years

xi: ivreg2 ex_gov_age_incr i.timeS_reform_age_incr dist_NRA $XVAR, cluster(gruppo) small partial($XVAR)
est store rob5_ageincr
xi: ivreg2 ex_gov_red_pen i.timeS_reform_red_pen dist_NRA $XVAR, cluster(gruppo) small partial($XVAR)
est store rob5_redpen
	
esttab rob5_ageincr rob5_redpen using "$output/tableA_2.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(*timeS* *dist_NRA*) ///
	starlevels(* .10 ** .05 *** .01)   ///
	mtitles("Chances age incr" "Chances red pen") title("Panel F: distance from national retirement age") ///
	nogaps append
	
	
